#version 330
#extension GL_EXT_gpu_shader4 : enable
//Funny LightMod01.fsh  by FranciscoGarcia
//https://www.shadertoy.com/view/lt2cRD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
#define EPS 0.001
#define MAX 20.0
#define STEPS 135
#define PI 3.14159

vec3 lig = vec3(0.0, 1.7, 0.4);
const float angle = 90.0;
const float fov = angle * 0.5 * PI / 180.0;

float sph(in vec3 p) {
  p.y -= 0.3*sin(5.0*p.x + 4.0*iTime);
  return distance(p, vec3(0.0)) - 1.0;
}
float plane( in vec3 p) {
  return p.y + 1.0;
}
float map(in vec3 p) {
  float d1,d2;
  d1 = sph(p);
  d2 = plane(p);
  return min(d1,d2);
}

vec3 normals(in vec3 p) {
  vec2 e = vec2(EPS, 0.0);
  vec3 gr = vec3( map(p + e.xyy) - map(p - e.xyy),
                  map(p + e.yxy) - map(p - e.yxy),
                  map(p + e.yyx) - map(p - e.yyx));
  return normalize(gr);
}

float diffuse(in vec3 nor){
  float diff;
  
  diff = max(0.0, dot(nor, -lig));
  return diff;
}

float trace(in vec3 ro, in vec3 rd) {
  float d, t;
  d=1.0;
  for( int i = 0; i<STEPS; i++) {
    if (d < EPS) break;
    d = map(ro+t*rd);
    t += d;
  }
  return t;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy*2.0 - iResolution.xy) / min(iResolution.x, iResolution.y);

 	vec3 ro = vec3(0.0,-0.2, 2.5);
  	vec3 rd =  normalize(vec3(sin(fov) * uv.x, sin(fov) * uv.y, -cos(fov)));

  	vec3 col = vec3(0.0);
  	float tr = trace(ro, rd);
    
  	if(tr < MAX){
    vec3 pos = ro + tr*rd;
    vec3 halfLE = normalize(lig-rd);
    vec3 nor = normals(pos);
    float dif = diffuse(nor);
    float intFact = 2000.0;
    float spec = pow(clamp(dot(halfLE, nor), 0.0, 1.0), intFact);
    float ligShp = sph(pos);

    col = vec3( dif + 0.2 / abs( 0.4 - ligShp*ligShp))*vec3(0.9) + spec;
    col += vec3(0.1, 0.25, 0.25)*clamp(nor.y, 0.0, 0.8);
    col *= exp(-tr*0.2);
    
  }
    
	gl_FragColor = vec4(col,1.0);
}